/** @file   interactive.h
 * @brief   Declaration Interactive - interface.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_ENG2D_INTERACTIVE_H
#define H_ENG2D_INTERACTIVE_H

#include <allegro.h>
#include "vec2d.h"

namespace eng2d {

/** @class  Interactive
 * @brief   Defines the interface for interactive objects.
 * @author  Tomi Lamminsaari
 *
 */
class Interactive
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================


  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	Interactive();


	/** Destructor
   */
	virtual ~Interactive();

	/** Copy constructor.
   * @param     rO                Reference to another Interactive
   */
  Interactive( const Interactive& rO );

	/** Assignment operator
   * @param     rO                Reference to another Interactive
   * @return    Reference to us.
   */
  Interactive& operator = ( const Interactive& rO );



  ///
  /// Methods
  /// =======

  /** An update method updates the contents and states of this object.
   */
  virtual void update() = 0;
  
  /** Draws the contents of this object on given bitmap.
   * @param     pB                Pointer to bitmap.
   * @param     offset            The offset value. This is needed when
   *                              translating the object from world coordinates
   *                              to screen coordinates.
   */
  virtual void redraw( BITMAP* pB, const Vec2D& offset ) const = 0;


  ///
  /// Getter methods
  /// ==============


protected:

  ///
  /// Members
  /// =======



private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif
